import React, {Component} from 'react';

let interval;
export default class UserSelector extends Component {

	constructor(props){
		super(props);

		this.state={
			selectedUser:0,
			enableSearch:false,
			searchText:'',
			searchedUsers:[],
			debounced:true,
			users:[]
		}

		this.setChange = this.setChange.bind(this);
		this.searchStudent=this.searchStudent.bind(this);
		this.setUser=this.setUser.bind(this);
	}

	componentWillMount(){
		this.setState({users:this.props.users});
	}

	

	componentWillUpdate(nextProps, nextState){
		if(nextProps.users.length > nextState.users.length){
			let users  = [...nextState.users];
			nextProps.users.map((user)=>{
				if(users.findIndex((u)=>{return parseInt(user.id) == parseInt(u.id)}) < 0){
					users.push(user);
				}
			});

			if(users.length > nextState.users.length){
				this.setState({users});
			}
		}
	}

	setChange(event){
		if(parseInt(event.target.value) >= 0){
			this.props.change(event);
			this.setState({enableSearch:false});
		}else{
			this.setState({enableSearch:true});
		}

	}	

	setUser(user_id){

		let users = [...this.state.users];

		let user = this.state.searchedUsers[this.state.searchedUsers.findIndex((student)=>{return student.id == user_id;})];
		users.push(user);

		let event = { target:{value:user_id},user:{id:user.id,name:user.name}};
		this.props.change(event);

		this.setState({users});
		this.setState({searchText:''});
		this.setState({enableSearch:false});
	}

	searchStudent(event){
		event.persist();
		this.setState({searchText:event.target.value});
		let $this=this;
		
		if(interval){
			clearTimeout(interval);
		}
		interval = setTimeout(() => {
			let unique_user_ids = [];

			if($this.state.users.length){
				$this.state.users.map((user)=>{
					if(unique_user_ids.indexOf(user.id) < 0){
						unique_user_ids.push(user.id);
					}
				});
			}

			let searchedUsers = [...$this.state.searchedUsers];

			fetch(`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/search/?s=${$this.state.searchText}&students=${JSON.stringify(unique_user_ids)}&security=${window.wplms_commissions.security}`)
	        .then(res => res.json())
	        .then((returnedusers)=>{

	        	if(returnedusers.length){
	        		returnedusers.map((user)=>{
	        			if(searchedUsers.findIndex((u)=>{return parseInt(user.id) == parseInt(u.id)}) < 0){
	        				searchedUsers.push(user);
	        			}
	        		});
	        	}

	        	if($this.state.searchedUsers.length < searchedUsers.length){
	        		console.log('setting State');
	        		$this.setState({searchedUsers});	
	        	}
	        });
	    },200);	
		
		
		
		//Throlle OR debounce make a API hit to get USer from DB
	}


	render(){

		let searchedUsers = [];

		
		if(this.state.searchText.length && this.state.searchedUsers.length){
			searchedUsers =[...this.state.searchedUsers];
			//searchedUsers = searchedUsers.filter((user)=>{return user.name.indexOf(this.state.searchText) >=0 });
		}else{
			searchedUsers =[...this.state.searchedUsers];
		}
		return (
			<div>
				<select onChange={this.setChange} value={this.props.value}>
	                <option value="0">{window.wplms_commissions.translations.select_student}</option>
	                <option value="-1">{window.wplms_commissions.translations.search_student}</option>
	                {
	                    this.state.users.map((user)=>{
	                        if(user.hasOwnProperty('name') && user.name){
	                            return (<option value={user.id} key={user.id}>{user.name}</option>)
	                        }
	                    })
	                }
	            </select>
	            {
	            	this.state.enableSearch?
	            		<div className="searchStudent">
	            			<input type="text" value={this.state.searchText} onChange={this.searchStudent} />
	            			{
	            				searchedUsers.length?
	            				<div className="studentList">
	            					{
	            						searchedUsers.map((student)=>{
	            							return (
	            								<div className="studentDetails" onClick={()=>this.setUser(student.id)}>
	            									<img src={student.image} />
	            									<span>{student.name}</span>
	            								</div>
            								);
	            						})
	            					}
	            				</div>
	            				:''
	            			}
	            		</div>
	            	:''
	            }
            </div>
		);
	}
}
