import React, {Component} from 'react';
import DateTimestamp from './date';
import DatePicker from "react-datepicker";
import UserSelector from "./select";

import "react-datepicker/dist/react-datepicker.css";
/*Chart Import*/
import { LineChart, Line, CartesianGrid, XAxis, YAxis, Tooltip, ResponsiveContainer } from 'recharts';


class Commissions extends Component { 

    constructor(props){
        super(props);

        this.state={
            records:[],
            payout_records:[],
            courses:[],
            currency:[],
            selectedCurrency:'',
            users:[],
            search:'',
            chart_data:[],
            payout_chart_data:[],
            startDate:0,
            endDate:0,
            requestedCommission:'',
            totalCommission:0,
            thresholdCommissionPayout:[],
            payoutsCommission:0,
            currencyCommission:'',
            selectedCourse:0, 
            selectedStudent:0,
            currentPage:1,
            commissions_maxRecords:1,
            payout_maxRecords:1,
            payout_last_requested:'',
            loading:true,
            perPage:parseInt(window.wplms_commissions.per_page,10)
        }
        this.handleChangeStart=this.handleChangeStart.bind(this);
        this.handleChangeEnd=this.handleChangeEnd.bind(this);
        this.setCourseChange=this.setCourseChange.bind(this);
        this.setStudentChange=this.setStudentChange.bind(this);
        this.displayCommissionsRecords=this.displayCommissionsRecords.bind(this);
        this.displayPayoutsRecords=this.displayPayoutsRecords.bind(this);
        this.fetchAtt = this.fetchAtt.bind(this);
        this.fetchCommissions=this.fetchCommissions.bind(this);
        this.paginationPages=this.paginationPages.bind(this);
        this.requestCommission=this.requestCommission.bind(this);
        this.setCurrencyChange=this.setCurrencyChange.bind(this);
        
    }

    componentWillMount() {
        let currencyUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/currency?security=${window.wplms_commissions.security}`;
            
        fetch(currencyUrl)
        .then(res => res.json())
        .then((allCurrency)=>{
            if(allCurrency.status) {
                this.setState({
                    currency:allCurrency.data, 
                    selectedCurrency:allCurrency.default,
                });
            }

            let url = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}?per_page=${this.state.perPage}&currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
            fetch(url)
            .then(res => res.json())
            .then((result) => {

                if(result.status){
                    this.setState({
                        loading: false,
                        records: result.data
                    }); 
                }

                let courseUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/courses?security=${window.wplms_commissions.security}`;
            
                fetch(courseUrl)
                .then(res => res.json())
                .then((allcourses)=>{

                    let courses =[];

                    allcourses.map((course)=>{
                        if(courses.findIndex((item)=>{return item.id === course.id}) < 0){
                            courses.push(course);
                        }
                    });
                    this.setState({courses});
                });

                let chartUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/chart/?currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
                
                fetch(chartUrl)
                .then(res => res.json())
                .then((chart_data)=>{
                    if(chart_data.status){
                        this.setState({
                            chart_data: chart_data.data
                        }); 
                    }
                });

                let thresholdUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/thresholdCommission/?security=${window.wplms_commissions.security}`;
                
                fetch(thresholdUrl)
                .then(res => res.json())
                .then((data)=>{
                    this.setState({thresholdCommissionPayout:data});
                });
                
                let countUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/?count=1&per_page=${this.state.perPage}&security=${window.wplms_commissions.security}`;
                
                fetch(countUrl)
                .then(res => res.json())
                .then((datas)=>{
                    if(datas.status){

                        this.setState({commissions_maxRecords:datas.count});
                    }
                    
                });

                let users = [];

                if(result.length ){
                    result.map((record)=>{
                        if(users.findIndex((user)=>{ return parseInt(user.id) === parseInt(record.user_id)}) < 0){
                            users.push({id:parseInt(record.user_id),'name':'...'});
                        }
                    });

                    if(users.length){
                        let unique_user_ids =[];
                        users.map((user)=>{
                            if(unique_user_ids.indexOf(user.id) < 0){
                                unique_user_ids.push(user.id);
                            }
                        });

                        fetch(`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/students/?students=${JSON.stringify(unique_user_ids)}&security=${window.wplms_commissions.security}`)
                        .then(res => res.json())
                        .then((users)=>{
                            this.setState({users});
                        });

                    }
                }

            })

  //Payouts          
            let payout_url = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/payouts?per_page=${this.state.perPage}&currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
            fetch(payout_url)
            .then(res => res.json())
            .then((result) => {
                if(result.status){
                    this.setState({
                        loading: false,
                        payout_records: result.data
                    }); 
                }

                let payout_countUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/payouts/?count=1&per_page=${this.state.perPage}&security=${window.wplms_commissions.security}`;
                
                fetch(payout_countUrl)
                .then(res => res.json())
                .then((datas)=>{
                    if(datas.status){

                        this.setState({payout_maxRecords:datas.count});
                    }
                    
                });

                let payout_chartUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/payoutChart/?currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
                fetch(payout_chartUrl)
                .then(res => res.json())
                .then((chart_data)=>{
                    if(chart_data.status){
                        this.setState({
                            payout_chart_data: chart_data.data
                        }); 
                    }
                });

                let last_request_url=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/last_payout_request/?security=${window.wplms_commissions.security}`;
                
                fetch(last_request_url)
                .then(res => res.json())
                .then((data)=>{
                    if(data && data.status){
                        this.setState({payout_last_requested:data.last_payout_request});
                    }
                });
            })

        });
        
    }

    fetchAtt(){

        let obj = {page:1,course_id:0,date_start:0 ,date_end:0,paginate:false };
        var d = new Date();
        if(this.state.selectedCourse){
            obj.course_id = this.state.selectedCourse;
        }

        if(this.state.selectedStudent){
            obj.student_id = this.state.selectedStudent;
        }

        if(this.state.selectedCurrency){
            obj.currency = this.state.selectedCurrency;
        }

        if(this.state.startDate){
            obj.date_start = Math.round(this.state.startDate.setHours(0,0)/1000) - d.getTimezoneOffset()*60;
        }
        if(this.state.endDate){
            obj.date_end = Math.round(this.state.endDate.setHours(23,59)/1000) - d.getTimezoneOffset()*60;
        }
        this.fetchCommissions(obj);
    }

    setPaged(currentPage){
        //console.log('clicked => '+currentPage);
        this.setState({currentPage});
        let obj = {page:currentPage,course_id:0,date_start:0,date_end:0,paginate:true};
        if(this.state.selectedCourse){
            obj.course_id = this.state.selectedCourse;
        }
        if(this.state.selectedCurrency){
            obj.currency = this.state.selectedCurrency;
        }

        if(this.state.startDate){
            obj.date_start = Math.round(this.state.startDate.setHours(0,0)/1000);
        }
        if(this.state.endDate){
            obj.date_end = Math.round(this.state.endDate.setHours(23,59)/1000);
        }
        
        this.fetchCommissions(obj);
    }

    fetchCommissions(obj){
        let records = [...this.state.records];
        this.setState({loading:true});
        if( (!obj.paginate)  || (obj.paginate && obj.page > 1 && obj.page*this.state.perPage > records.length)){


            let url = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/?per_page=${this.state.perPage}&page=${obj.page}&date_start=${obj.date_start}&date_end=${obj.date_end}&course_id=${obj.course_id}&currency=${obj.currency}&security=${window.wplms_commissions.security}`;
            let users = [...this.state.users];

            fetch(url)
            .then(res => res.json())
            .then((rec)=>{
                if(rec.status){
                    let rrecords = rec.data;

                    this.setState({loading:false});

                    if(!obj.paginate){

                        let pagUrl = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/?count=1&per_page=${this.state.perPage}&page=${obj.page}&date_start=${obj.date_start}&date_end=${obj.date_end}&course_id=${obj.course_id}&currency=${obj.currency}&security=${window.wplms_commissions.security}`;
                        fetch(pagUrl)
                        .then(res => res.json())
                        .then((maxRecords)=>{
                            this.setState({commissions_maxRecords:maxRecords.count});
                        });
                        
                        records = rrecords;

                    }else{

                        rrecords.map((record)=>{
                            if(records.findIndex((r)=>{return r.order_item_id === record.order_item_id}) < 0){
                                records.push(record);
                            }
                        });
                    }

                    if(rrecords.length && window.wplms_commissions.type === 'commissions'){
                        let unique_user_ids =[];

                        rrecords.map((record)=>{
                            if(users.findIndex((user)=>{ return parseInt(user.id) === parseInt(record.user_id)}) < 0){
                                if(unique_user_ids.indexOf(record.user_id) < 0){
                                    unique_user_ids.push(record.user_id);
                                }
                            }
                        });
                        
                        if(unique_user_ids.length){

                            fetch(`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/students/?students=${JSON.stringify(unique_user_ids)}&security=${window.wplms_commissions.security}`)
                            .then(res => res.json())
                            .then((newusers)=>{
                                if(newusers.length){
                                    newusers.map((user)=>{
                                        users.push(user);
                                    });
                                    this.setState({users});
                                }
                            });

                        }
                    }

                    let chartUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/chart/?date_start=${obj.date_start}&date_end=${obj.date_end}&course_id=${obj.course_id}&currency=${obj.currency}&security=${window.wplms_commissions.security}`;
                    fetch(chartUrl)
                    .then(res => res.json())
                    .then((chart_data)=>{
                        this.setState({chart_data:chart_data.data});

                    });
                    this.setState({records});
                    
                }
            });

  //Payouts          
            let payout_url = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/payouts?per_page=${this.state.perPage}&page=${obj.page}&date_start=${obj.date_start}&date_end=${obj.date_end}&currency=${obj.currency}&security=${window.wplms_commissions.security}`;
            
            fetch(payout_url)
            .then(res => res.json())
            .then((result) => {
                if(result.status){
                    this.setState({
                        loading: false,
                        payout_records: result.data
                    }); 
                }
            })

            let payout_chartUrl=`${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/payoutChart/?date_start=${obj.date_start}&date_end=${obj.date_end}&currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
                fetch(payout_chartUrl)
                .then(res => res.json())
                .then((chart_data)=>{
                    if(chart_data.status){
                        this.setState({
                            payout_chart_data: chart_data.data
                        }); 
                    }
                });

        }else{
            this.setState({loading:false});
        }
    }

    handleChangeStart(date){
        this.setState({currentPage:1});
        this.setState({startDate:date});
    }
    handleChangeEnd(date){
        this.setState({currentPage:1});
        this.setState({endDate:date});
    }
    requestCommission(records){
        let url = `${window.wplms_commissions.api_url}instructor/${window.wplms_commissions.user_id}/requestPayouts/?currency=${this.state.selectedCurrency}&security=${window.wplms_commissions.security}`;
        fetch(url)
        .then(res => res.json())
        .then((requestCommission)=>{
            this.setState({requestedCommission:requestCommission});
        });
    }
    setCourseChange(event){
        
        if(event.target.value === "0"){
            event.target.value=0;
        }
        this.setState({currentPage:1});
        this.setState({selectedCourse:event.target.value});
    }
    setCurrencyChange(event){
        
        if(event.target.value === "0"){
            event.target.value=0;
        }
        this.setState({selectedCurrency:event.target.value});
    }
    setStudentChange(event){
        
        if(event.target.value === "0"){
            event.target.value=0;
        }

        if(event.hasOwnProperty('user')){
            let users = [...this.state.users];
            users.push(event.user);
            this.setState({users});

        }
        
        this.setState({currentPage:1});
        this.setState({selectedStudent:event.target.value});
    }
    paginationPages(records, $type){

        let recordsLength = records.length;


        if(records.length === this.state.records.length){
            if($type === 'commissions'){
                recordsLength= this.state.commissions_maxRecords;
            } else{
                recordsLength= this.state.payouts_maxRecords;
            }
        }

        let $return =[];
        let addfrontdots = true;let addenddots=true;
        let maxPage = Math.floor(recordsLength/this.state.perPage);
        if(Math.floor(recordsLength%this.state.perPage) != 0 ){
            maxPage = maxPage+1;
        }

        for(let i=1;i<=maxPage;i++){


            if(this.state.currentPage === i){
                $return.push(<span className="current" key={i}>{i}</span>);
            }else{

                if(maxPage => 5){
                    if(i === 1  || i === maxPage || i === (this.state.currentPage-1) || i=== (this.state.currentPage+1)){

                        if( i === maxPage && this.state.currentPage !== maxPage -1){
                            $return.push(<span key={i}>{i}</span>);
                        }else{
                            $return.push(<a onClick={()=>this.setPaged(i)} className="inactive" key={i}>{i}</a>);
                        }
                        
                    }else{
                        if(addfrontdots && i > 1 && i < (this.state.currentPage-1)){
                            addfrontdots = false;
                            $return.push(<span key={i}>...</span>);
                        }
                        if(addenddots && i < maxPage && i > (this.state.currentPage+1)){
                            addenddots = false;
                            $return.push(<span key={i}>...</span>);
                        }
                    }

                }else{
                    if(i < this.state.currentPage || i === (this.state.currentPage+1)){
                        $return.push(<a onClick={()=>this.setPaged(i)} className="inactive" key={i}>{i}</a>);
                    }else{
                        if( i === maxPage && i > 1){
                            $return.push(<span key={i}>{i}</span>);
                        }
                    }
                }

                
                
            }
        }

        return $return;
    }

    displayCommissionsRecords(records){


        if(records.length){

            let rreturn=[];
            records.map((record,index)=>{

                let user = this.state.users[this.state.users.findIndex((u)=>{return parseInt(u.id) === parseInt(record.user_id)})]; 

                let course = this.state.courses[this.state.courses.findIndex((c)=>{return c.id === record.course_id})];
                
                rreturn.push(
                    <div className="record" key={index}>
                        <div>
                            <div className="date">
                                <span>{record.date}</span>
                            </div>
                        </div>

                        <div>
                            <div className="course">
                                {
                                    (typeof course === 'undefined' || !course.hasOwnProperty('name') || !course.name)?'':
                                    <span>{course.name}</span>
                                }
                            </div>
                        </div>

                        <div>
                            {
                                (user)?
                                    <div className="commission_student_profile">
                                        <span>{user.name}</span>
                                    </div>
                                :''
                            }
                            
                        </div>

                        <div>
                            <div className="instructor_commission">
                                <span>{record.commission} </span>
                                <span>{record.currency}</span>
                            </div>
                        </div>
                        
                    </div>
                );
            });            
            
            return rreturn;            
                     
        }else{
            return(
                <div className="nocommissionrecords"><div className="message">
                {window.wplms_commissions.translations.no_records}</div></div>
            )
        }      
    }

    displayPayoutsRecords(records){


        if(records.length){

            let rreturn=[];
            records.map((record,index)=>{

                rreturn.push(
                    <div className="record" key={index}>
                        
                        <div>
                            <div className="date">
                                <span>{record.date}</span>
                            </div>
                        </div>
                        
                        <div>
                            <div className="instructor_commission payouts">
                                <span>{record.payout} </span>
                                <span>{record.currency}</span>
                            </div>
                        </div>

                    </div>
                );
            });            
            
            return rreturn;            
                     
        }else{
            return(
                <div className="nocommissionrecords"><div className="message">
                {window.wplms_commissions.translations.no_records}</div></div>
            )
        }      
    }

    render() { 

        // console.log(this.state);

        let course ={};
        let chart_data = [...this.state.chart_data];
        let payout_chart_data = [...this.state.payout_chart_data];

        let records = [...this.state.records];
        let payout_records = [...this.state.payout_records];
        let commissions_maxRecords = this.state.commissions_maxRecords;
        let payout_last_requested = this.state.payout_last_requested;

        var colorCode = 'rgb(' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ',' + (Math.floor(Math.random() * 256)) + ')';
        
        if(this.state.selectedCourse > 0){
            records = records.filter((record,index)=>{
                    return record.course_id === this.state.selectedCourse;
            });
        }

        if(this.state.selectedStudent > 0){
            records = records.filter((record,index)=>{
                    return parseInt(record.user_id) === parseInt(this.state.selectedStudent);
            });
        }

        if(this.state.selectedDate){

            let selectedDate = new Date(this.state.selectedDate.getTime());
            records = records.filter((record,index)=>{
                
                let record_commission_timestamp = new Date().getTime() - (parseInt(window.wplms_commissions.timestamp,10) - parseInt(record.commission_timestamp))*1000;

                return record_commission_timestamp > selectedDate.setUTCHours(0,0) && record_commission_timestamp <  selectedDate.setUTCHours(23,59);
                
            });
        }

        let rrecords = [...records];
        records = records.filter((record,index)=>{

            if(this.state.currentPage){
                if(index >= (this.state.currentPage - 1)*this.state.perPage && index < (this.state.currentPage)*this.state.perPage){
                    return record;
                }
            }
        });

        if(rrecords.length !== this.state.records.length){
            commissions_maxRecords = rrecords.length;
        }
        var datas = [];
        var lineCdata = [];

        chart_data.map(function (data,index) {
            datas[index] = {name: data.name, Commission: data.commission, amt: 2400};
        });
        if(datas[0]){
            lineCdata = Object.values(datas);
        }

        var payout_datas = [];
        var payout_lineCdata = [];
        payout_chart_data.map(function (data,index) {
            payout_datas[index] = {name: data.name, Payout: data.payout, amt: 2400};
        });
        if(payout_datas[0]){
            payout_lineCdata = Object.values(payout_datas);
        }
        let thresholdCommissionPayout = this.state.thresholdCommissionPayout;
        let selectedCurrency = this.state.selectedCurrency;
        var total_commission = 0;
        var payout = 0;
        var threshold = 0;
        var currency = '';
        thresholdCommissionPayout.map(function (data,index){ 
            if(selectedCurrency == data.currency){
                total_commission = data.total_commission;
                payout = data.payout;
                threshold = data.threshold + payout;
                currency = data.currency;
            }
        });

        return (
            <div>
                {
                    (this.state.loading)?
                        <div className="commissionsloader"><svg width="120" height="30" viewBox="0 0 120 30" xmlns="http://www.w3.org/2000/svg" fill="#222"> <circle cx="15" cy="15" r="15"> <animate attributeName="r" from="15" to="15" begin="0s" dur="0.8s" values="15;9;15" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="1" to="1" begin="0s" dur="0.8s" values="1;.5;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="60" cy="15" r="9" fill-opacity="0.3"> <animate attributeName="r" from="9" to="9" begin="0s" dur="0.8s" values="9;15;9" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="0.5" to="0.5" begin="0s" dur="0.8s" values=".5;1;.5" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="105" cy="15" r="15"> <animate attributeName="r" from="15" to="15" begin="0s" dur="0.8s" values="15;9;15" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="1" to="1" begin="0s" dur="0.8s" values="1;.5;1" calcMode="linear" repeatCount="indefinite" /> </circle> </svg></div>
                    :
                        <div className="commissionsRecords">
                         {
                            (window.wplms_commissions.type === 'payout')?
                                <div className="request_payouts">
                                    <div>
                                        <p><strong>{window.wplms_commissions.translations.commission_balance}</strong>{total_commission} {currency}</p>
                                        <p><strong>{window.wplms_commissions.translations.payouts_balance}</strong>{payout} {currency}</p>
                                        {
                                            (total_commission >= threshold && total_commission !== 0)?
                                            <p>{window.wplms_commissions.translations.commission_payouts_text}</p>
                                            :
                                            <p>{window.wplms_commissions.translations.commission_failed_payouts_text}</p>
                                        }
                                    </div>
                                        {
                                            (total_commission >= threshold && total_commission !== 0)?
                                                [
                                                    (this.state.requestedCommission && this.state.requestedCommission == currency) ?

                                                        <div key="payout_last_requested1">
                                                        <button className="button" >{window.wplms_commissions.translations.requested_payouts}</button>
                                                        <br/>

                                                        {payout_last_requested?<span className="lastRequested">{window.wplms_commissions.translations.last_requested} {payout_last_requested}</span>:''}

                                                        </div>
                                                    :
                                                        <div key="payout_last_requested2">
                                                        <button className="button" onClick={this.requestCommission}>{window.wplms_commissions.translations.request_payouts}</button> 
                                                        <br/>
                                                        {payout_last_requested?<span className="lastRequested">{window.wplms_commissions.translations.last_requested} {payout_last_requested}</span>:''}


                                                        </div>
                                                ]
                                            :''
                                        }

                                    
                                </div>
                            :''
                        }
                        <div className="commissionsSorter">
                            <div className="startDate">
                                
                                <DatePicker
                                    placeholderText={window.wplms_commissions.translations.start_date}
                                    isClearable={true}
                                    selected={this.state.startDate}
                                    selectsStart
                                    startDate={this.state.startDate}
                                    endDate={this.state.endDate}
                                    onChange={this.handleChangeStart}
                                />

                            </div>
                            <div className="endDate">

                                <DatePicker
                                    placeholderText={window.wplms_commissions.translations.end_date}
                                    isClearable={true}
                                    selected={this.state.endDate}
                                    selectsEnd
                                    startDate={this.state.startDate}
                                    endDate={this.state.endDate}
                                    onChange={this.handleChangeEnd}
                                    minDate={this.state.startDate}
                                />
                            </div>
                            {
                                (window.wplms_commissions.type === 'commission')?
                                    <div className="selectCourses">
                                        <select onChange={this.setCourseChange} value={this.state.selectedCourse}>
                                            <option value="0">{window.wplms_commissions.translations.select_course}</option>
                                            {
                                                this.state.courses.map((course)=>{
                                                    if(course.hasOwnProperty('name') && course.name){
                                                        return (<option value={course.id} key={course.id}>{course.name}</option>)
                                                    }
                                                })
                                            }
                                        </select>
                                    </div>
                                :''
                            }
                            <div className="selectCurrency">
                                <select onChange={this.setCurrencyChange} value={this.state.selectedCurrency}>
                                    {
                                        this.state.currency.map((currency)=>{
                                            return (<option value={currency.currency} key={currency.currency} >{currency.currency}</option>)
                                        })
                                    }
                                </select>
                            </div>
                            <button className="button" onClick={this.fetchAtt}>{window.wplms_commissions.translations.go}</button>
                        </div>
                        {
                            (window.wplms_commissions.type === 'commission')?
                                <div className ="chart">
                                    <ResponsiveContainer height={400} width='100%'>
                                      <LineChart data={lineCdata}
                                        margin={{top: 30, right: 0, left: 0, bottom: 30}}>
                                        <Line type="monotone" dataKey="Commission" stroke={colorCode} strokeWidth={2}/>
                                        <CartesianGrid stroke="#ccc"/>
                                        <XAxis dataKey="name" padding={{ left: 30, right: 30 }}/>
                                        <YAxis />
                                        <Tooltip />
                                      </LineChart>
                                    </ResponsiveContainer>

                                </div>
                            :
                            <div className ="chart">
                                    <ResponsiveContainer height={400} width='100%'>
                                      <LineChart data={payout_lineCdata}
                                        margin={{top: 30, right: 0, left: 0, bottom: 30}}>
                                        <Line type="monotone" dataKey="Payout" stroke={colorCode} strokeWidth={2}/>
                                        <CartesianGrid stroke="#ccc"/>
                                        <XAxis dataKey="name" padding={{ left: 30, right: 30 }}/>
                                        <YAxis />
                                        <Tooltip />
                                      </LineChart>
                                    </ResponsiveContainer>

                                </div>
                        }
                        <div className="commissionsData">
                            {
                                (window.wplms_commissions.type === 'commission')?
                                <div>
                                    <div className="record recordHeader"><strong>{window.wplms_commissions.translations.date}</strong><strong>{window.wplms_commissions.translations.course}</strong><strong>{window.wplms_commissions.translations.student}</strong><strong>{window.wplms_commissions.translations.commissions}</strong></div>
                                    <span className='display'> {this.displayCommissionsRecords(records)} </span> 
                                </div>
                                :
                                <div>
                                    <div className="record recordHeader"><strong>{window.wplms_commissions.translations.date}</strong><strong>{window.wplms_commissions.translations.commissions}</strong></div>
                                    <span className='display'> {this.displayPayoutsRecords(payout_records)} </span>
                                </div>
                            }

                            {
                                (window.wplms_commissions.type === 'commission')?
                                    [
                                        (this.state.commissions_maxRecords > 1)?
                                            <div className="pagination" key={records.length}>
                                                <span>{window.wplms_commissions.translations.showing} {((this.state.currentPage-1)*this.state.perPage)+'-'+((this.state.currentPage == 1 && records.length < this.state.perPage)?records.length:this.state.currentPage*this.state.perPage)} {window.wplms_commissions.translations.of} {commissions_maxRecords}</span>
                                                {this.paginationPages(rrecords, 'commissions')}
                                            </div>
                                        :''

                                    ]
                                :
                                    [
                                        (this.state.payouts_maxRecords > 1)?
                                            <div className="pagination" key={payout_records.length}>
                                                <span>{window.wplms_commissions.translations.showing} {((this.state.currentPage-1)*this.state.perPage)+'-'+((this.state.currentPage == 1 && records.length < this.state.perPage)?records.length:this.state.currentPage*this.state.perPage)} {window.wplms_commissions.translations.of} {commissions_maxRecords}</span>
                                                {this.paginationPages(payout_records, 'payouts')}
                                            </div>
                                        :''

                                    ]

                            }
                        
                        </div> 
                         
                    </div> 
                }
            </div>
        );
    }
}

export default Commissions;
